﻿# Run the PowerShell Script in Administrator Mode
if (!([Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)) {
    Start-Process PowerShell -Verb RunAs "-NoProfile -ExecutionPolicy Bypass -Command `"cd '$pwd'; & '$PSCommandPath';`"";
    exit;
}

try {
    # Make sure Powershell Execution Policy is bypassed to run the following script
    Set-ExecutionPolicy Bypass -Scope Process
}
catch {
    # echo "Error occurred when bypassing Powershell Execution Policy: $_"
    Start-Sleep -Seconds 60
}

# Command to check State of each IIS FeatureName: Get-WindowsOptionalFeature -Online | where FeatureName -like 'IIS-*'

try {
    # Turn on Internet Information Services
    if ((Get-WindowsOptionalFeature -Online | where FeatureName -like 'IIS-WebServerRole').State -ne "Enabled") {
        Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServerRole
    }
}
catch {
    # echo "Error occurred when turning on Internet Information Services: $_"
    Start-Sleep -Seconds 30
}
Start-Sleep -Seconds 30
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServerRole
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServer
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-CommonHttpFeatures
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpErrors
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-ApplicationDevelopment
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-HealthAndDiagnostics
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpLogging
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-Security
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-RequestFiltering
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-Performance
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServerManagementTools
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-StaticContent
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-DefaultDocument
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-DirectoryBrowsing
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpCompressionStatic
#Enable-WindowsOptionalFeature -Online -FeatureName IIS-ManagementConsole
